﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Fable;

namespace FablePluginExample
{
    public class HealthCheat : Script
    {
        // DoOnce - A simple boolean value used to toggle execution code on\off
        bool DoOnce = false;

        // Update - Called once per frame
        public override void Update()
        {
            // Check the value of DoOnce (Execute if false)
            if (!DoOnce) // <-This = That-> if (DoOnce == false)
            {
                Player.MaxHealth = 250;
                DoOnce = true; // Set DoOnce to true, disabling further execution of this block of code
            }
        }

        // OnCast - Called once per cast
        public override void OnCast()
        {
            // If the players health is less than his max health
            if (Player.Health < Player.MaxHealth)
                Player.Health++; // Increment health by 1.
        }
    }
}
