#pragma once
#ifndef __ATMOS_TYPES_H__
#define __ATMOS_TYPES_H__

enum ESoundType
{
	SOUND_BANK_DEFAULT=1,
	SOUND_BANK_MAIN_DIALOGUE,
	SOUND_BANK_MAIN_DIALOGUE_2,
	SOUND_BANK_SCRIPT_DIALOGUE,
	SOUND_BANK_SCRIPT_DIALOGUE_2,
	NO_SOUND_TYPES,
};

enum EAtmosType
{
	ATMOS_NULL = 0,
	ATMOS_INN = NO_SOUND_TYPES,
	ATMOS_NIGHT,
	ATMOS_VILLAGE,
	ATMOS_WOODLAND,
	ATMOS_COUNTRY,
	ATMOS_THUNDERSTORM,
	ATMOS_RIVER,
	ATMOS_WATERFALL,
	ATMOS_OCEAN,
	ATMOS_SHORE,
	ATMOS_LAKE,
	ATMOS_GRANNYSHOUSE,
	ATMOS_DARKWOOD,
	ATMOS_DARKWOODLAKE,
	ATMOS_HOBBESCAVE,
	ATMOS_HANGINGTREEPATH,
	ATMOS_GRAVEYARD,
	ATMOS_HOOKCOAST,
	ATMOS_HOOKCOASTVILLAGE,
	ATMOS_WITCHWOOD,
	ATMOS_ORCHARDFARM,
	ATMOS_ORCHARDFRUITTREES,
	ATMOS_PICNICAREA,
	ATMOS_WATERFALLSMALL,
	ATMOS_WINDMILL,
	ATMOS_FOUNTAIN,
	ATMOS_KRAKEN_WATER_FLOW,
	ATMOS_RAIN,
	ATMOS_KRAKENCHAMBER,
	ATMOS_SECRETPASSAGE,
	ATMOS_PRISON,
	ATMOS_TAVERNCELLAR,
	ATMOS_ARENACELLS,
	ATMOS_ARENASTADIUM,
	ATMOS_ARENAEXTERIOR,
	ATMOS_HAUNTEDHOUSE,
	ATMOS_GUILD,
	ATMOS_OAKVALERAID,
	ATMOS_BURNINGBRIDGE,
	ATMOS_ARCHONS_TOWER,
	ATMOS_BORDELLO,
	ATMOS_DEMON_DOOR_LOOKOUT_POINT,
	ATMOS_DEMON_DOOR_BORDELLO,
	ATMOS_DEMON_DOOR_NECROPOLIS,
	ATMOS_LOST_BAY,
	ATMOS_LOST_BAY_SHORE,
	ATMOS_NORTHERN_WASTE_ARCHONS_SHRINE,
	ATMOS_NORTHERN_WASTE_FOOTHILLS,
	ATMOS_NORTHERN_WASTE_NECROPOLIS,
	ATMOS_SNOWSPIRE,
	ATMOS_LAVA,
	NO_ATMOS_TYPES,
};


enum EMusicType
{
	MUSIC_NONE= NO_ATMOS_TYPES,
	MUSIC_EXPLORE,
	MUSIC_FRESCO_WEDDING,	
	MUSIC_CHAPEL_OF_EVIL,	
	MUSIC_DANGER1,			
	MUSIC_DANGER2,			
	MUSIC_GUILD,			
	MUSIC_GUILD_DAY,		
	MUSIC_GUILD_NIGHT,		
	MUSIC_HALL_OF_HEROES,	
	MUSIC_TEMPLE_OF_LIGHT,	
	MUSIC_ARENA_FANFARE,	
	MUSIC_BANDIT_CAMP,		
	MUSIC_BOWERSTONE,		
	MUSIC_CAVES,			
	MUSIC_DARKWOOD,		
	MUSIC_GRAVEYARD,		
	MUSIC_GRAVEYARD_PASSAGE,
	MUSIC_GREATWOOD,		
	MUSIC_HAUNTED_HOUSE,	
	MUSIC_LOOKOUT_POINT,	
	MUSIC_OAKVALE,			
	MUSIC_WITCHWOOD,		
	MUSIC_QUEST_SUCCEEDED,	
	MUSIC_QUEST_FAILED,	
	MUSIC_PRISON,			
	MUSIC_HOOK_COAST,		
	MUSIC_KNOTHOLE_GLADE,	
	MUSIC_EXECUTION_TREE,	
	MUSIC_GIBBET_WOODS,	
	MUSIC_KRAKEN_CHAMBER,	
	MUSIC_INTERLUDE,
	MUSIC_ARENA_FIGHT,
	MUSIC_ARENA_FANFARE_01,
	MUSIC_ARENA_FANFARE_02,
	MUSIC_ARENA_FANFARE_03,
	MUSIC_ARENA_FANFARE_04,
	MUSIC_ARENA_FANFARE_05,
	MUSIC_ARENA_FANFARE_06,
	MUSIC_ARENA_FANFARE_07,
	MUSIC_ARENA_FANFARE_08,
	MUSIC_ARENA_FANFARE_09,
	MUSIC_ARENA_FANFARE_10,
	MUSIC_CUTSCENE_DEAD_DAD,
	MUSIC_CUTSCENE_FEET,
	MUSIC_CUTSCENE_GUILD_CEREMONY,
	MUSIC_CUTSCENE_TWINBLADE,
	MUSIC_CUTSCENE_THERESA_01,
	MUSIC_CUTSCENE_THERESA_02,
	MUSIC_CUTSCENE_WIZARD_BATTLE_INTRO,
	MUSIC_CUTSCENE_WIZARD_BATTLE_OUTRO,
	MUSIC_CUTSCENE_PRISON_MOTHER,
	MUSIC_CUTSCENE_JACK_BOSS_FIGHT_INTRO,
	MUSIC_CUTSCENE_JACK_BOSS_FIGHT_OUTRO,
	MUSIC_CUTSCENE_JACK_CAPTURES,
	MUSIC_CUTSCENE_GUILD_ARRIVAL,
	MUSIC_CUTSCENE_COLLECT_FIREHEART,
	MUSIC_CUTSCENE_DRAGON_DEATH,		
	MUSIC_CUTSCENE_DRAGON_FIGHT_INTRO,		
	MUSIC_CUTSCENE_DRAGON_FIGHT_OUTRO_EVIL,		
	MUSIC_CUTSCENE_DRAGON_FIGHT_OUTRO_GOOD,
	MUSIC_CUTSCENE_DRAGON_FIGHT_OUTRO_CHOICE,		
	MUSIC_CUTSCENE_ONE_YEAR_LATER,		
	MUSIC_CUTSCENE_ORACLE_AWAKENS,		
	MUSIC_CUTSCENE_SCYTHE_MESSAGE,		
	MUSIC_CUTSCENE_SOUL2_MOTHER_INTRO,		
	MUSIC_CUTSCENE_SOUL2_MOTHER_SUCCESS,		
	MUSIC_CUTSCENE_SOUL3_GUILDMASTER_INTRO,		
	MUSIC_CUTSCENE_SUMMON_SHIP_INTRO,		
	MUSIC_CUTSCENE_SUMMON_SHIP_OUTRO,		
	MUSIC_CUTSCENE_SOUL3_GUILDMASTER_OUTRO_EVIL,
	MUSIC_CUTSCENE_SOUL3_GUILDMASTER_OUTRO_GOOD,
	MUSIC_CUTSCENE_GATE_OPENS_BRIAR_ROSE,		
	MUSIC_CUTSCENE_GATE_OPENS_SCYTHE,		
	MUSIC_INTRO,
};

enum EReverbEnvironmentType
{
	REVERB_ENVIRONMENT_NULL = 0,
	REVERB_ENVIRONMENT_EXTERNAL,
	REVERB_ENVIRONMENT_CAVE,
	REVERB_ENVIRONMENT_HALL,
	REVERB_ENVIRONMENT_GUILD,
	REVERB_ENVIRONMENT_GUILD_SMALL,
	REVERB_ENVIRONMENT_SMALL_ROOM,
	REVERB_ENVIRONMENT_SCHOOL,
};

enum EMusicSetType
{
	MUSIC_SET_NULL = 1,
	MUSIC_SET_FRESCO_WEDDING,	
	MUSIC_SET_CHAPEL_OF_EVIL,	
	MUSIC_SET_GUILD,			
	MUSIC_SET_GUILD_DAY,		
	MUSIC_SET_GUILD_NIGHT,		
	MUSIC_SET_HALL_OF_HEROES,	
	MUSIC_SET_TEMPLE_OF_LIGHT,	
	MUSIC_SET_ARENA_FANFARE,	
	MUSIC_SET_BANDIT_CAMP,		
	MUSIC_SET_BOWERSTONE,		
	MUSIC_SET_CAVES,			
	MUSIC_SET_DARKWOOD,			
	MUSIC_SET_GRAVEYARD,		
	MUSIC_SET_GRAVEYARD_PASSAGE,
	MUSIC_SET_GREATWOOD,		
	MUSIC_SET_HAUNTED_HOUSE,	
	MUSIC_SET_LOOKOUT_POINT,	
	MUSIC_SET_OAKVALE,			
	MUSIC_SET_WITCHWOOD,		
	MUSIC_SET_QUEST_SUCCEEDED,	
	MUSIC_SET_QUEST_FAILED,		
	MUSIC_SET_BOSS,				
	MUSIC_SET_DANGER,			
	MUSIC_SET_PRISON,
	MUSIC_SET_HOOK_COAST,		
	MUSIC_SET_KNOTHOLE_GLADE,	
	MUSIC_SET_EXECUTION_TREE,	
	MUSIC_SET_GIBBET_WOODS,		
	MUSIC_SET_KRAKEN_CHAMBER,	
	MUSIC_SET_INTERLUDE,
	MUSIC_SET_DANGER_ONLY,
	MUSIC_SET_DRAGON,		
	MUSIC_SET_ARENA_FIGHT,
	MUSIC_SET_ARENA_FANFARE_01,
	MUSIC_SET_ARENA_FANFARE_02,
	MUSIC_SET_ARENA_FANFARE_03,
	MUSIC_SET_ARENA_FANFARE_04,
	MUSIC_SET_ARENA_FANFARE_05,
	MUSIC_SET_ARENA_FANFARE_06,
	MUSIC_SET_ARENA_FANFARE_07,
	MUSIC_SET_ARENA_FANFARE_08,
	MUSIC_SET_ARENA_FANFARE_09,
	MUSIC_SET_ARENA_FANFARE_10,
	MUSIC_SET_CUTSCENE_DEAD_DAD,
	MUSIC_SET_CUTSCENE_FEET,
	MUSIC_SET_CUTSCENE_GUILD_CEREMONY,
	MUSIC_SET_CUTSCENE_TWINBLADE,
	MUSIC_SET_CUTSCENE_THERESA_01,
	MUSIC_SET_CUTSCENE_THERESA_02,
	MUSIC_SET_CUTSCENE_WIZARD_BATTLE_INTRO,
	MUSIC_SET_CUTSCENE_WIZARD_BATTLE_OUTRO,
	MUSIC_SET_CUTSCENE_PRISON_MOTHER,
	MUSIC_SET_CUTSCENE_JACK_BOSS_FIGHT_INTRO,
	MUSIC_SET_CUTSCENE_JACK_BOSS_FIGHT_OUTRO,
	MUSIC_SET_CUTSCENE_JACK_CAPTURES,
	MUSIC_SET_CUTSCENE_GUILD_ARRIVAL,
	MUSIC_SET_CUTSCENE_COLLECT_FIREHEART,
	MUSIC_SET_CUTSCENE_DRAGON_DEATH,		
	MUSIC_SET_CUTSCENE_DRAGON_FIGHT_INTRO,		
	MUSIC_SET_CUTSCENE_DRAGON_FIGHT_OUTRO_EVIL,		
	MUSIC_SET_CUTSCENE_DRAGON_FIGHT_OUTRO_GOOD,
	MUSIC_SET_CUTSCENE_DRAGON_FIGHT_OUTRO_CHOICE,		
	MUSIC_SET_CUTSCENE_ONE_YEAR_LATER,		
	MUSIC_SET_CUTSCENE_ORACLE_AWAKENS,		
	MUSIC_SET_CUTSCENE_SCYTHE_MESSAGE,		
	MUSIC_SET_CUTSCENE_SOUL2_MOTHER_INTRO,		
	MUSIC_SET_CUTSCENE_SOUL2_MOTHER_SUCCESS,		
	MUSIC_SET_CUTSCENE_SOUL3_GUILDMASTER_INTRO,		
	MUSIC_SET_CUTSCENE_SUMMON_SHIP_INTRO,		
	MUSIC_SET_CUTSCENE_SUMMON_SHIP_OUTRO,		
	MUSIC_SET_CUTSCENE_SOUL3_GUILDMASTER_OUTRO_EVIL,
	MUSIC_SET_CUTSCENE_SOUL3_GUILDMASTER_OUTRO_GOOD,
	MUSIC_SET_CUTSCENE_GATE_OPENS_BRIAR_ROSE,		
	MUSIC_SET_CUTSCENE_GATE_OPENS_SCYTHE,		
	MUSIC_SET_INTRO,	
	NO_MUSIC_SETS,
};

#endif //__ATMOS_TYPES_H__
