//***************************************************************************************************************
#definition_template	BUILDING	BUILDING_TEMPLATE
	Health				15000;
	
	DieOffTimer			0;
	IsSelfIlluminating	FALSE;

	IsDrawable				TRUE;
	
	Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	Graphic.RenderSizeX		1;
	Graphic.AnimStep 		0;
	UseHighDetailQuadTree	TRUE;
	WallMaterial			MATERIAL_ROCK;
	FloorMaterial			MATERIAL_WOOD;
	ReverbEnvironmentType	REVERB_ENVIRONMENT_SMALL_ROOM;
	ReverbEnvironmentLevel	1.0;
	OutsideOcclusionLevel	1.0;
	
	RenderFadeDistance	THING_FADE_DIST_LONG;
	PersistenceFlags	EPF_STATIC;
	CanComeBetweenCameraAndObservedThing	FALSE;

	Components.Add("CTCPhysicsStandard");
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCGraphicAppearanceStaticMesh");
	
	Components.Add("CTCHitLocations");
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_PHYSICS_MESH);
	<\CHitLocationsDef>
	
	<CPhysicsDef>
		InteractionFlags	PHYSICS_IMMOVEABLE | PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity		0;
		Friction		1;
		AirResistance	1;
		Mass			1000;
	<\CPhysicsDef>

	AlwaysFrameUpdate		TRUE;

	Components.Add("CTCMeshAutomaticEntityCreator");	

#end_definition




//***************************************************************************************************************
#definition_template		BUILDING	BUILDING_VILLAGE_TEMPLATE  specialises BUILDING_TEMPLATE
	Components.Add("CTCSmokeGenerator");	
	Components.Add("CTCVillageMember");
	Components.Add("CTCTrespassable");
	Components.Add("CTCBuyableHouse");
	<CVillageMemberDef>
		NeedsVillageToFunctionCorrectly		TRUE;
	<\CVillageMemberDef>
	
	<CBuyableHouseDef>
		IsBuyable					FALSE;
		Price[0]					5000;
		Rent[0]						250;
		DaysBetweenRentPayments		1;
		MaxRentBags					3; //7;
		IsBuyableWithoutSignpost	BFALSE;
	<\CBuyableHouseDef>

	<CSmokeGeneratorDef>           
		GenerationDistance		32.0;
		ParticleEmitter CHIMNEY_SMOKE_01;
	<\CSmokeGeneratorDef>           

	GroupDef				G_VILLAGE_GENERIC;
#end_definition

//***************************************************************************************************************
#definition_template		BUILDING	BUILDING_VILLAGE_WALLS_TEMPLATE  specialises BUILDING_VILLAGE_TEMPLATE
	WallMaterial			MATERIAL_ROCK;
	FloorMaterial			MATERIAL_ROCK;
	<CVillageMemberDef>
		NeedsVillageToFunctionCorrectly		FALSE;
	<\CVillageMemberDef>
#end_definition

//***************************************************************************************************************
#definition_template		BUILDING	BUILDING_VILLAGE_TAVERN_TEMPLATE  specialises BUILDING_VILLAGE_TEMPLATE
	SimBuildingDef					SIM_BUILDING_TAVERN;
	
	Components.Add("CTCTavern");
	Components.Add("CTCShop");

	<CTavernDef>
		BedCost							30;
	<\CTavernDef>

	<CShopDef>
		AlwaysOpen						TRUE;
		MinPriceMultiplierForItemToBeWanted 2;
		SellPriceMultiplier						1.35; // pubs more expensive
		BuyPriceMultiplier							0.8;

		// Note: the Beer and other stock data has been moved into the specific tavern Defs
		DefaultStock[0].Type			OBJECT_BEER_TANKARD;
		DefaultStock[0].MaxStock		30;
		DefaultStock[0].RestockPeriod	1;
		DefaultStock[0].SalesPerDay		0.0;

		MinGoldForDonation				0;
		MaxGoldForDonation				0;
		MaxMoralityForDonation			0.0;
		LogarithmicPower				0.0;
	<\CShopDef>
#end_definition

//***************************************************************************************************************
#definition_template		BUILDING	BUILDING_VILLAGE_SHOP_TEMPLATE	specialises BUILDING_VILLAGE_TEMPLATE
	SimBuildingDef				SIM_BUILDING_SHOP;

	Components.Add("CTCShop");
	Components.Add("CTCThingOwner");

	<CShopDef>
		InitialHawkingPhrase			TEXT_AI_SHOP_KEEPER_HAWKING_INSIDE_GENERIC;
		ReplyToRequestPhrase			TEXT_AI_SHOP_KEEPER_REPLYTOREQUEST;
		CustomerFollowPhrase			TEXT_AI_SHOP_KEEPER_FOLLOWME;
		ThankingPhrase					TEXT_AI_SHOP_KEEPER_THANKING;

		BuyPriceMultiplier							1.0;
		SellPriceMultiplier							1.0;
		
		PriceReductionFractionPerItem				0.014; //0.01;
		MaxPriceReductionFractionDueToStockCount	0.7; //0.5;
		
		MinPriceMultiplierForItemToBeWanted			1.01; //temporarily high until 'wanted' weapon crash fixed //1.2
		
		MaxPriceToDisplay							5000;
		MinTimeToSteal								4;		// measured in seconds
		MaxTimeToSteal								25;

		// Prices that shop will buy items for are scaled by one of these values depending on his opinion of you
		AttitudeBuyPriceMultiplierDefault								0.80;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_RESPECT]		0.95;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_AWE]			0.90;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_DISDAIN]		0.70;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_FEAR]			0.60;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_FRIENDLINESS]	0.70;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_WORSHIP]		1.00;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_RIDICULOUS]	0.60;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_OFFENSIVE]		0.50;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_AGREEABLE]		0.70;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_UGLY]			0.70;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_ATTRACTED]		0.90;
		AttitudeBuyPriceMultiplier[OPINION_ATTITUDE_TYPE_LOVE]			0.90;

		AttitudeSellPriceMultiplierDefault								1.15;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_RESPECT]		1.05;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_AWE]			1.00;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_DISDAIN]		1.25;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_FEAR]			1.40;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_FRIENDLINESS]	1.20;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_WORSHIP]		1.00;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_RIDICULOUS]	1.10;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_OFFENSIVE]	1.30;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_AGREEABLE]	1.20;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_UGLY]			1.15;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_ATTRACTED]	1.10;
		AttitudeSellPriceMultiplier[OPINION_ATTITUDE_TYPE_LOVE]			1.00;

		// These values govern how much the MaxStock (minimum quantity of stock that shop will have after restocking) change
		// Currently they are set to 'dry up' trade routes and quickly revert to normal
		MaxStockChangePerSell	-0.2;
		MaxStockChangePerBuy	0.2;
		MaxStockRevertPerDay	0.2;

		IsStockDisplayPermanent			TRUE;

		MinGoldForDonation				0;
		MaxGoldForDonation				0;
		MaxMoralityForDonation			0.0;
		LogarithmicPower				0.0;
	<\CShopDef>

	<CBuyableHouseDef>
		IsBuyable						TRUE;
		InitiallyEmpty					FALSE;
		Price[0]						15000;
		Rent[0]							30;
	<\CBuyableHouseDef>
#end_definition

//***************************************************************************************************************
#definition_template BUILDING BUILDING_VILLAGE_MARKETSTALL_TEMPLATE specialises BUILDING_VILLAGE_SHOP_TEMPLATE
	SimBuildingDef			SIM_BUILDING_MARKETSTALL;
	Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	
	WallMaterial			MATERIAL_WOOD;
	Components.Remove("CTCTrespassable");
	
	<CShopDef>
		IsStockDisplayPermanent			false;
	<\CShopDef>

	<CBuyableHouseDef>
		Price[0]						200;
		Rent[0]							2;
	<\CBuyableHouseDef>
	
	GroupDef				G_VILLAGE_BOWERSTONE;
#end_definition
