#pragma once
#ifndef __CONTROLLER_DEF_H__
#define __CONTROLLER_DEF_H__

//-----------------------------------------------------------------------------------------------
enum EControllerType
{
	CONTROLLER_NONE,
	CONTROLLER_XBOX_PAD,
	CONTROLLER_KEYBOARD,
	CONTROLLER_MOUSE,
};

//-----------------------------------------------------------------------------------------------
enum EInputButtonEventType
{
	INPUT_BUTTON_TYPE_NULL,
	INPUT_BUTTON_TYPE_PRESSED,
	INPUT_BUTTON_TYPE_HELD,
	INPUT_BUTTON_TYPE_RELEASED,
};

//-----------------------------------------------------------------------------------------------
enum EInputModifierType
{
	INPUT_MODIFIER_NULL = 0,
	INPUT_MODIFIER_TOGGLE,
	INPUT_MODIFIER_HOLD,
};

//-----------------------------------------------------------------------------------------------
enum EXboxControllerButton
{
	XBOX_PAD_UNDEFINED_BUTTON = 0,
	XBOX_PAD_X_BUTTON = 1,
	XBOX_PAD_Y_BUTTON = 2,
	XBOX_PAD_BLACK_BUTTON = 3,
	XBOX_PAD_A_BUTTON = 4,
	XBOX_PAD_B_BUTTON = 5,
	XBOX_PAD_WHITE_BUTTON = 6,
	XBOX_PAD_LEFT_TRIGGER = 7,
	XBOX_PAD_RIGHT_TRIGGER = 8,
	XBOX_PAD_LEFT_STICK_BUTTON = 9,
	XBOX_PAD_RIGHT_STICK_BUTTON = 10,
	XBOX_PAD_START_BUTTON = 11,
	XBOX_PAD_BACK_BUTTON = 12,
	XBOX_PAD_DPAD_UP_BUTTON = 13,
	XBOX_PAD_DPAD_DOWN_BUTTON = 14,
	XBOX_PAD_DPAD_LEFT_BUTTON = 15,
	XBOX_PAD_DPAD_RIGHT_BUTTON = 16,
	XBOX_PAD_LEFT_ANALOGUE_STICK = 17, // the sticks do not map to buttons and so will have to be treated as a special case
	XBOX_PAD_RIGHT_ANALOGUE_STICK = 18,
};

//-----------------------------------------------------------------------------------------------
enum EMouseButtonControl
{
	MOUSE_BUTTON_NULL_CONTROL,
	MOUSE_BUTTON_LEFT_CONTROL,
	MOUSE_BUTTON_RIGHT_CONTROL,
	MOUSE_BUTTON_MIDDLE_CONTROL,
	MOUSE_MOVEMENT,
	MOUSE_WHEEL_MOVEMENT,
	MOUSE_WHEEL_MOVEMENT_UP,
	MOUSE_WHEEL_MOVEMENT_DOWN,
	MOUSE_BUTTON_4_CONTROL,
	MOUSE_BUTTON_5_CONTROL,
	MOUSE_BUTTON_6_CONTROL,
	MOUSE_BUTTON_7_CONTROL,
	MOUSE_BUTTON_8_CONTROL,
};

//-----------------------------------------------------------------------------------------------
enum EGameAction
{
	GAME_ACTION_NULL,
	GAME_ACTION_LOCK_TARGET,
	GAME_ACTION_OPEN_INVENTORY,
	GAME_ACTION_OPEN_IN_GAME_MENU,
	GAME_ACTION_TOGGLE_MINI_MAP,
	GAME_ACTION_PAUSE,
	GAME_ACTION_INTERACT,
	GAME_ACTION_BLOCK,
	GAME_ACTION_SPECIAL_ATTACK,
	GAME_ACTION_ATTACK,
	GAME_ACTION_FIRE_RANGED_WEAPON,
	GAME_ACTION_UNARMED_ATTACK,
	GAME_ACTION_ARMED_MELEE_ATTACK,
	GAME_ACTION_UNSHEATHE_MELEE_WEAPON,
	GAME_ACTION_UNSHEATHE_RANGED_WEAPON,
	GAME_ACTION_SHEATHE_MELEE_WEAPON,
	GAME_ACTION_SHEATHE_RANGED_WEAPON,
	GAME_ACTION_TOGGLE_SILENT_MOVE,
	GAME_ACTION_TOGGLE_CINEMATIC_AND_USER_CAMERA,
	GAME_ACTION_TOGGLE_FIRST_PERSON_VIEW,
	GAME_ACTION_SKIP_PAST_TEXT,
	GAME_ACTION_SKIP_CUT_SCENE,
	GAME_ACTION_ANSWER_QUESTION_YES,
	GAME_ACTION_ANSWER_QUESTION_NO,
	GAME_ACTION_ANSWER_QUESTION_THIRD,
	GAME_ACTION_INVENTORY_SELECT,
	GAME_ACTION_ATTRACT_EXPERIENCE_ORBS,
	GAME_ACTION_ROTATE_GUI_SCREENS_LEFT,
	GAME_ACTION_ROTATE_GUI_SCREENS_RIGHT,
	GAME_ACTION_JUMP,
	GAME_ACTION_SPRINT,
	GAME_ACTION_RUN,
	GAME_ACTION_SNEAK,
	GAME_ACTION_INVENTORY_A,
	GAME_ACTION_INVENTORY_B,
	GAME_ACTION_INVENTORY_X,
	GAME_ACTION_INVENTORY_Y,
	GAME_ACTION_INVENTORY_UP,
	GAME_ACTION_INVENTORY_DOWN,
	GAME_ACTION_INVENTORY_LEFT,
	GAME_ACTION_INVENTORY_RIGHT,
	GAME_ACTION_INVENTORY_WHITE,
	GAME_ACTION_TAVERN_GAMES_INSTRUCTIONS,
	GAME_ACTION_FISHING_REEL_IN,
	GAME_ACTION_FISHING_CANCEL,
	GAME_ACTION_TOGGLE_FIRST_PERSON_TARGETING,
	GAME_ACTION_FIRST_PERSON_TARGET_LOCK,
	GAME_ACTION_FIRST_PERSON_ZOOM_IN,
	GAME_ACTION_GENERAL_LEAVE_PLAYER_MODE,
	GAME_ACTION_DEBUG_JUMP_1,
	GAME_ACTION_DEBUG_JUMP_2,
	GAME_ACTION_DEBUG_CAMERA,
	GAME_ACTION_DEBUG_SHIFT,
	GAME_ACTION_TAKE_PHOTO_FOR_PHOTOJOURNAL,
	GAME_ACTION_ASSIGNABLE_SPECIAL_MOVE,
	GAME_ACTION_QUICK_ACCESS_ITEM,
	GAME_ACTION_CONTEXT_SENSITIVE_ITEM,
	GAME_ACTION_CYCLE_THROUGH_SPELLS,
	GAME_ACTION_COIN_GOLF_CANCEL_AIM,
	GAME_ACTION_CONFIRM_RESET_TO_FRONT_END,
	GAME_ACTION_MOVEMENT,
	GAME_ACTION_CAMERA_ROTATE,
	GAME_ACTION_CAMERA_ROTATE_LEFT,
	GAME_ACTION_CAMERA_ROTATE_RIGHT,
	GAME_ACTION_CAMERA_ZOOM_IN,
	GAME_ACTION_CAMERA_ZOOM_OUT,
	GAME_ACTION_ORACLE_MINIGAME_UP,
	GAME_ACTION_ORACLE_MINIGAME_DOWN,
	GAME_ACTION_ORACLE_MINIGAME_LEFT,
	GAME_ACTION_ORACLE_MINIGAME_RIGHT,
	GAME_ACTION_ORACLE_MINIGAME_QUIT,
	GAME_ACTION_MOVE_MOUSE_ON_GUI,
	GAME_ACTION_TOGGLE_LIVE_GUI,
	GAME_ACTION_OPEN_EXPRESSION_MENU,
	GAME_ACTION_TOGGLE_DEACTIVATE_LOCK_TARGET,
	GAME_ACTION_FIRST_PERSON_LOOKAROUND,
	GAME_ACTION_INVENTORY_UNSELECT,
	GAME_ACTION_CAMERA_MOVE_DOUBLE_AXIS,
	GAME_ACTION_CHARGE_GUILD_SEAL,
	GAME_ACTION_TAVERN_GAME_MOVEMENT,
	GAME_ACTION_TAVERN_GAME_CAMERA,
	GAME_ACTION_TAVERN_GAME_ACTION_BUTTON,
	GAME_ACTION_TAVERN_GAME_ALTERNATE_BUTTON,
	GAME_ACTION_TAVERN_GAME_QUIT,
	GAME_ACTION_PROJECTILE_TARGETING_ANALOGUE_ZOOM,
	GAME_ACTION_TOGGLE_PASSIVE_AGGRESSIVE_MODE,
	GAME_ACTION_ACTIVATE_SPELL_MODE,
	GAME_ACTION_EXPRESSION_SHIFT,
	GAME_ACTION_SCROLL_DESCRIPTION_UP,
	GAME_ACTION_SCROLL_DESCRIPTION_DOWN,
	GAME_ACTION_OPEN_WEAPONS_MENU,
	GAME_ACTION_OPEN_CLOTHING_MENU,
	GAME_ACTION_OPEN_ITEMS_MENU,
	GAME_ACTION_OPEN_CURRENT_QUESTS_MENU,
	GAME_ACTION_CYCLE_THROUGH_SPELLS_KEYBOARD,
	GAME_ACTION_TOGGLE_KILL_EVERYTHING_MODE,
	GAME_ACTION_OPEN_MAGIC_MENU,
	GAME_ACTION_OPEN_EXPRESSIONS_MENU,
	GAME_ACTION_OPEN_PERSONALITY_MENU,
	GAME_ACTION_OPEN_LOGBOOK_MENU,
	GAME_ACTION_OPEN_MAP_MENU,

	GAME_ACTION_SCROLL_MENU,
	GAME_ACTION_ZOOM_MAP_OUT,
	GAME_ACTION_ZOOM_MAP_IN,
	GAME_ACTION_SCROLL_MAP_LEFT,
	GAME_ACTION_SCROLL_MAP_RIGHT,
	GAME_ACTION_SCROLL_MAP_DOWN,
	GAME_ACTION_SCROLL_MAP_UP,
	GAME_ACTION_OPTIONS_SLIDER_LEFT,
	GAME_ACTION_OPTIONS_SLIDER_RIGHT,
	
	GAME_ACTION_DIGITAL_ANALOGUE_ZOOM_IN,
	GAME_ACTION_DIGITAL_ANALOGUE_ZOOM_OUT,

	GAME_ACTION_TOGGLE_VIEW_HERO_MODE,
	GAME_ACTION_CENTRE_CAMERA,

	GAME_ACTION_BETTING,

	GAME_ACTION_COUNT,
};

#endif	// __CONTROLLER_DEF_H__
