#pragma once
#ifndef __GAME_EVENT_TYPES_H__
#define __GAME_EVENT_TYPES_H__

//*************************************************************************
enum	EGameEventType
{
	GAME_EVENT_NULL = 0,
	GAME_EVENT_UPDATE_FRAME,								//DATA - ULONG[0]=Checksum, ULONG[1]=GlobalSeed, ULONG[2]=ChecksumWorldFrame
	GAME_EVENT_QUIT,										//DATA - None
	GAME_EVENT_SET_EXCLUSIVE_MODE,							//DATA - UBYTE[0]=on(0, 1)
	GAME_EVENT_SET_DISPLAY_MODE,							//DATA - UWORD[0]=width, UWORD[1]=height, UBYTE[4]=depth
	GAME_EVENT_SET_EDITOR_MODE,								//DATA - UBYTE[0]=on(0, 1)
	GAME_EVENT_FIRST_PERSON_VIEW_START,						//DATA -
	GAME_EVENT_CREATURE_CHEAT,								//DATA - NONE
	GAME_EVENT_PLAYER_RESPAWN,								//DATA - NONE at present
	GAME_EVENT_SET_PAUSE_MODE,								//DATA - UBYTE on
	GAME_EVENT_SET_SLOW_MOTION,								//DATA - UBYTE on
	GAME_EVENT_SET_FREE_CAMERA_MODE,						//DATA - UBYTE on
	GAME_EVENT_USE_FREE_CAMERA,								//DATA - UBYTE on
	GAME_EVENT_CONTROLLED_CREATURE_BLOCK,					//DATA - UBYTE=block y/n
	GAME_EVENT_TEMP_WORLD_EVENT,							//DATA - whatever you fancy!
	GAME_EVENT_APPLY_SCRIPTED_MAP_BRUSHES,					//DATA
	GAME_EVENT_CREATURE_MOVEMENT,							//DATA - ULONG creature id, float[0]=X axis, float[1]=Y axis
	GAME_EVENT_CREATURE_USE_OBJECT,							//DATA - UHUGE creature id, UHUGE object id
	GAME_EVENT_CONTROLLED_CREATURE_TALK,					//DATA -
	GAME_EVENT_CONTROLLED_CREATURE_LEARN_EXPRESSION,		//DATA - UBYTE[0] type of expression
	GAME_EVENT_CONTROLLED_CREATURE_DROP_OBJECT,				//DATA -
	GAME_EVENT_CONTROLLED_CREATURE_ZTARGET,
	GAME_EVENT_CONTROLLED_CREATURE_USE_ABILITY,
	GAME_EVENT_CONTROLLED_CREATURE_START_SNEAK,
	GAME_EVENT_CONTROLLED_CREATURE_STOP_SNEAK,
	GAME_EVENT_CLICK_PAST_TEXT,								//DATA - none
	GAME_EVENT_OPEN_HERO_INFO_SCREEN,						//DATA - ULONG player mode to enter
	GAME_EVENT_CLOSE_HERO_INFO_SCREEN,						//DATA - none
	GAME_EVENT_CLOSE_IN_GAME_MENU,							//DATA - none
	GAME_EVENT_QUESTION_ANSWERED,							//DATA - SLONG[0]=answer (yes or no), ULONG[1]=player mode to enter
	GAME_EVENT_CONTROLLED_CREATURE_START_THROW_OBJECT,		//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_END_THROW_OBJECT,		//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_SHEATHE_WEAPON,			//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_UNSHEATHE_MELEE_WEAPON,	//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_UNSHEATHE_RANGED_WEAPON,	//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_PLAYER_INTERACTION,		//DATA - UBYTE[0] type of interaction
	GAME_EVENT_CONTROLLED_CREATURE_GIVE_ITEM_TO_TARGET,		//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_UNFREEZE_CONTROLS,		//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_ROLL,					//DATA - none
	GAME_EVENT_USE_QUICK_ACCESS_ITEM,						//DATA - SLONG[0] quick access index
	GAME_EVENT_USE_QUICK_ACCESS_ITEM_IN_CUTSCENE,			//DATA - SLONG[0] quick access index, UBYTE[1] humour rating on a scale of 0 to 1
	GAME_EVENT_CHARGE_QUICK_ACCESS_ITEM,					//DATA - SLONG[0] quick access index, UBYTE[1] charge on/off
	GAME_EVENT_PUT_AWAY,									//DATA - none
	GAME_EVENT_CREATURE_STRAFE,								//DATA - float[0]=X axis, float[1]=Y axis, UBYTE[2]=whether to roll
	GAME_EVENT_MOVE_HERO_TO_REGION,							//DATA - float[0]=X coord, float[1]=Y coord, float[2]=Z coord, float[3]=XY angle, UBYTE[4]=via teleporter, UBYTE[5]=allow during cutscenes, UBYTE[6]=via door
	GAME_EVENT_FIRST_PERSON_TARGETING,						//DATA - no no no no
	GAME_EVENT_CONTROLLED_CREATURE_DEFAULT,					//DATA - no no no no
	GAME_EVENT_EXPRESSION_FOLLOW,							//DATA - none
	GAME_EVENT_EXPRESSION_WAIT,								//DATA - none
	GAME_EVENT_USE_PROJECTILE_WEAPON,
	GAME_EVENT_CONTROLLED_CREATURE_JUMP,					//DATA - none
	GAME_EVENT_SPIRIT_MOVEMENT,								//DATA - no no no no
	GAME_EVENT_OPEN_HERO_CENTRE_DOOR,						//DATA - SLONG[0]=door type, UHUGE[1]=hero centre
	GAME_EVENT_CLOSE_HERO_CENTRE_DOOR,						//DATA - UHUGE[0]=hero centre
	GAME_EVENT_SPIRIT_ATTACK,								//DATA - none at present
	GAME_EVENT_CREATURE_SPRINT,								//DATA - SLONG 0 for off, 1 for on
	GAME_EVENT_SPIRIT_RETURN_TO_HERO,						//DATA - none
	GAME_EVENT_SKIP_CUT_SCENE,								//DATA - none
	GAME_EVENT_USE_PROJECTILE_WEAPON_THIRD_PERSON,			//DATA - none
	GAME_EVENT_CHARGE_UP_WILL_SPELL,						//DATA - none
	GAME_EVENT_LOAD_GAME_FROM_IN_GAME_MENU,					//DATA - SLONG save game index
	GAME_EVENT_CONTROLLED_CREATURE_BLOCK_END,				//DATA - none
	GAME_EVENT_CONTROLLED_CREATURE_DEACTIVATE_ZTARGET,		//DATA = none
	GAME_EVENT_REMOVE_CURRENT_MODE,							//DATA = none
	GAME_EVENT_CONTROLLED_CREATURE_LIGHTNING,				//DATA = none
	GAME_EVENT_CONTROLLED_CREATURE_DEACTIVATE_LIGHTNING,	//DATA = none
	GAME_EVENT_CLOSE_LIVE_GUI,								//DATA = none
	GAME_EVENT_CLOSE_PHOTO_CAPTURE,							//DATA = none
	GAME_EVENT_TAKE_THE_BLOODY_SCREENSHOT,					//DATA = none
	GAME_EVENT_TOGGLE_CONSOLE,								//DATA = none
	GAME_EVENT_OPEN_PC_SKILLS_MENU,							//DATA = none
	GAME_EVENT_OPEN_PC_MSN_CHAT_MENU,						//DATA = none
	GAME_EVENT_OPEN_PC_INVENTORY_MENU,						//DATA = none
	GAME_EVENT_OPEN_PC_OPTIONS_MENU,						//DATA = none
	GAME_EVENT_OPEN_PC_PHOTO_JOURNAL_MENU,					//DATA = none
	GAME_EVENT_OPEN_PC_MAP_MENU,							//DATA = none
	GAME_EVENT_OPEN_PC_BUY_TRADING_MENU,					//DATA = none
	GAME_EVENT_OPEN_PC_SELL_TRADING_MENU,					//DATA = none
	GAME_EVENT_OPEN_PC_WANTED_TRADING_MENU,					//DATA = none
	GAME_EVENT_OPEN_PC_STATUS_MENU,							//DATA = none
	GAME_EVENT_OPEN_PC_SCOREBOARD,							//DATA = none
	GAME_EVENT_DELETE_MENU_COMPONENTS,						//DATA = none
	GAME_EVENT_TOGGLE_PASSIVE_AGGRESSIVE_MODE,				//DATA = none
	GAME_EVENT_DELETE_TRADE_ACTIVE_MENU,					//DATA = none
	GAME_EVENT_TOGGLE_KILL_EVERYTHING_MODE,					//DATA = none
	GAME_EVENT_TOGGLE_VIEW_HERO_MODE,						//DATA = none
	GAME_EVENT_CENTRE_CAMERA,								//DATA = none
	NO_GAME_EVENTS,
};

//*************************************************************************

#endif // __GAME_EVENT_TYPES_H__
