#pragma once
#ifndef __MISC_DEF_TYPES_H__
#define __MISC_DEF_TYPES_H__

//-----------------------------------------------------------------------------------------------
enum ENoiseType
{
	NOISE_TYPE_CONTINUOUS,
	NOISE_TYPE_ONCE_ONLY,
};

//-----------------------------------------------------------------------------------------------
enum EDoorTriggerType
{
	DOOR_TRIGGER_ON_PERSON,
	DOOR_TRIGGER_MANUAL,
};

//-----------------------------------------------------------------------------------------------
enum ETrapType
{
	TRAP_TYPE_TRIGGER_ONCE_ONLY,
	TRAP_TYPE_TRIGGER_AND_RESET,
	TRAP_TYPE_TRIGGER_AND_PLAY_CONTINUOUS,
	TRAP_TYPE_PLAY_CONTINUOUS,
	TRAP_TYPE_TRIGGER_AND_DIE,
};

//-----------------------------------------------------------------------------------------------
enum ETrapTriggerType
{
	TRAP_TRIGGER_MANUAL,
	TRAP_TRIGGER_PROXIMITY,
};

//-----------------------------------------------------------------------------------------------
enum EClockHandType
{
	CLOCKHAND_SECOND,
	CLOCKHAND_MINUTE,
	CLOCKHAND_HOUR,
};

//-----------------------------------------------------------------------------------------------
enum ERumbleType
{
	RUMBLE_EVENT_NULL = 0,
	RUMBLE_EVENT_WILL,
	RUMBLE_EVENT_DAMAGED,
	RUMBLE_EVENT_HITTING,
	RUMBLE_EVENT_QUAKE,
};

//-----------------------------------------------------------------------------------------------
enum EWillUIType
{
	WILL_UI_NULL = 0,
	WILL_UI_BUILD,
	WILL_UI_SELF,
	WILL_UI_FRIENDLY_CREATURE,
	WILL_UI_ORDERABLE_CREATURE,
	WILL_UI_HOSTILE_CREATURE,
	WILL_UI_NEUTRAL_CREATURE,
	WILL_UI_FRIENDLY_BUILDING,
	WILL_UI_HOSTILE_BUILDING,
};

//-----------------------------------------------------------------------------------------------
enum ESlotProperty
{
	SLOT_PROPERTY_NORMAL = 0,
	SLOT_PROPERTY_LAMP,
};

//-----------------------------------------------------------------------------------------------
enum EPlayerInteractionTypes
{
	PLAYER_INTERACTION_GREET = 0,
	PLAYER_INTERACTION_INSULT,
	PLAYER_INTERACTION_THREATEN,
	PLAYER_INTERACTION_BRIBE,
	PLAYER_INTERACTION_FLIRT,
	PLAYER_INTERACTION_GIVING_GIFT,

	PLAYER_INTERACTION_YES_NO_QUESTION,
};

//-----------------------------------------------------------------------------------------------
enum EAttitude
{
	ATTITUDE_FRIENDLY = 0,
	ATTITUDE_STRANGER,
	ATTITUDE_FAWNING,
	ATTITUDE_DISMISSIVE,
	ATTITUDE_RIDICULING,
	ATTITUDE_FEAR,
	ATTITUDE_HATE,
	ATTITUDE_INSULTED,
	ATTITUDE_INSULTED2,
	ATTITUDE_INSULTED3,
	ATTITUDE_ATTRACTED,
	ATTITUDE_IRRITATED,
	ATTITUDE_IRRITATED2,
	ATTITUDE_TERRIFIED,
	ATTITUDE_HOMICIDAL,
	ATTITUDE_OUTRAGED,
	ATTITUDE_LOVE,
	ATTITUDE_HARASSED,
	MAX_ATTITUDES,
};

//-----------------------------------------------------------------------------------------------
enum EConversationAttitude
{
	CONVERSATION_ATTITUDE_NULL = 0,
	CONVERSATION_ATTITUDE_NEUTRAL,
	CONVERSATION_ATTITUDE_LOVE,
	CONVERSATION_ATTITUDE_ANGER,
	CONVERSATION_ATTITUDE_FEAR,
	CONVERSATION_ATTITUDE_GLEE,
	CONVERSATION_ATTITUDE_SADNESS,
	CONVERSATION_ATTITUDE_RIDICULE,
	CONVERSATION_ATTITUDE_FRIENDLY,
	CONVERSATION_ATTITUDE_BELLIGERENT,
	CONVERSATION_ATTITUDE_CAGED,
	CONVERSATION_ATTITUDE_HOLDING_SWORD,
	MAX_CONVERSATION_ATTITUDES,
};

//-----------------------------------------------------------------------------------------------
enum ENavigatorType
{
	NAV_INIT_GROUND = 1,
	NAV_INIT_FLYER,
};

//-----------------------------------------------------------------------------------------------
enum EExpressionType
{
	EXPRESSION_NULL=0,
	EXPRESSION_DEFAULT,
	EXPRESSION_FEAR,
	EXPRESSION_HAPPY,
	EXPRESSION_CONFUSED,
	EXPRESSION_FURTIVE,
	EXPRESSION_SERIOUS,
	EXPRESSION_SQUINT,
	EXPRESSION_EVIL,
	EXPRESSION_CONTENT,
};

//-----------------------------------------------------------------------------------------------
enum EWaterType
{
	WATER_TYPE_NULL = 0,
	WATER_TYPE_LAKE,
	WATER_TYPE_RIVER,
	WATER_TYPE_SEA,
	WATER_TYPE_REFLECTIVE_SEA,
	WATER_TYPE_NON_REFLECTIVE_SEA,
	WATER_TYPE_OLD,
	WATER_TYPE_DUMMY_SHORE_POINT,
	WATER_TYPE_ICE,
	WATER_TYPE_COUNT,
};

//-----------------------------------------------------------------------------------------------
enum EMinimapThemeType
{
	MINIMAP_THEME_TYPE_NONE = 0,
	MINIMAP_THEME_TYPE_GRASS,
	MINIMAP_THEME_TYPE_WATER,
	MINIMAP_THEME_TYPE_SNOW,
	MINIMAP_THEME_TYPE_CLIFF,
	MINIMAP_THEME_TYPE_EARTH,
	MINIMAP_THEME_TYPE_FOLIAGE,
	MINIMAP_THEME_TYPE_WOOD,
	MINIMAP_THEME_TYPE_BUILDING,
};

//-----------------------------------------------------------------------------------------------
enum EMiniMapMarkerType
{
	MAP_MARKER_TYPE_HERO,
	MAP_MARKER_TYPE_QUEST_CORE,
	MAP_MARKER_TYPE_QUEST_FEAT,
	MAP_MARKER_TYPE_QUEST_OPTIONAL,
	MAP_MARKER_TYPE_QUEST_VIGNETTE,
	MAP_MARKER_TYPE_INTERESTING,
	MAP_MARKER_TYPE_TELEPORT,
	MAP_MARKER_TYPE_TELEPORT_INACTIVE,
	MAP_MARKER_TYPE_HOUSE,
	MAP_MARKER_TYPE_HOUSE_FOR_SALE,
	MAP_MARKER_TYPE_DEMON_DOOR,
	MAP_MARKER_TYPE_REGION_EXIT,
	MAP_MARKER_TYPE_REGION_CORE,
	MAP_MARKER_TYPE_REGION_OPTIONAL,
	MAP_MARKER_TYPE_WIFE,
	MAP_MARKER_TYPE_ATTRACTED,
	MAP_MARKER_TYPE_ENEMY,
	MAP_MARKER_TYPE_HENCHMAN,
	MAP_MARKER_TYPE_TRADER,
};

//-----------------------------------------------------------------------------------------------
enum EScriptAIPriority
{
	SCRIPT_AI_PRIORITY_LOWEST,
	SCRIPT_AI_PRIORITY_LOW,
	SCRIPT_AI_PRIORITY_MEDIUM,
	SCRIPT_AI_PRIORITY_HIGH,
	SCRIPT_AI_PRIORITY_HIGHEST,
};

//-----------------------------------------------------------------------------------------------
enum EImageOverlayType
{
	IMAGE_OVERLAY_TYPE_NONE = 0,
	IMAGE_OVERLAY_TYPE_ALPHA_FADE,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_LEFT,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_TOP,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_RIGHT,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_BOTTOM,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_TOPLEFT,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_TOPRIGHT,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_BOTTOMLEFT,
	IMAGE_OVERLAY_TYPE_WIPE_FROM_BOTTOMRIGHT,

	IMAGE_OVERLAY_TYPE_COUNT
};

//-----------------------------------------------------------------------------------------------
namespace NConversationTypes
{
	enum EConversationProtagonist
	{
		NONE,
		SPEAKER,
		SPEAKEE,
	};

	enum EConversationCameraPosition
	{
		IN_FRONT_OF_FACE,
		LEFT_SHOULDER,
		RIGHT_SHOULDER,
		BEHIND_LEFT_SHOULDER_NEAR,
		BEHIND_LEFT_SHOULDER_FAR,
		BEHIND_RIGHT_SHOULDER_NEAR,
		BEHIND_RIGHT_SHOULDER_FAR,
		LEFT_OF_TORSO_NEAR,
		LEFT_OF_TORSO_FAR,
		RIGHT_OF_TORSO_NEAR,
		RIGHT_OF_TORSO_FAR,
		POS_LEFT,
		POS_RIGHT,
	};

	enum EConversationCameraFocus
	{
		FOCUS_FACE,
		FOCUS_10,
		FOCUS_25,
		FOCUS_33,
		FOCUS_50,
		FOCUS_HIGH,
		FOCUS_LEVEL,
		FOCUS_LOW,
	};

	enum EConversationCameraZoomType
	{
		NO_ZOOM,
		SLOW_ZOOM,
		FAST_ZOOM,
	};

	enum EConversationCameraView
	{
		VIEW_WIDE,
		VIEW_MEDIUM,
		VIEW_CLOSE,
	};
}

//-----------------------------------------------------------------------------------------------
namespace NSpeechGainManager
{
	enum EDialogueLayer
	{
		DIALOGUE_LAYER_FOREGROUND,
		DIALOGUE_LAYER_MIDGROUND,
		DIALOGUE_LAYER_BACKGROUND,

		DIALOGUE_LAYER_LAST,
	};
}

//-----------------------------------------------------------------------------------------------
enum EScriptingStateGroups
{
	ESSG_NONE = 0,
	ESSG_PERFORM_ACTION_PHYSICAL,
	ESSG_PERFORM_ACTION_VERBAL,
	ESSG_PERFORM_ACTION_AURAL,

	ESSG_WANDER_NEAR,

	ESSG_FOLLOW_PATH,
	ESSG_FOLLOW_RANDOM,
	ESSG_FOLLOW_NEAREST,
	ESSG_WALK_TO_RANDOM,
	ESSG_WALK_TO_NEAREST_DIFFERENT,
	ESSG_RUN_AT_HERO_AND_ATTACK_UNTIL_DEAD,
};

//-----------------------------------------------------------------------------------------------
enum EAIStateGroupType
{
	AI_STATE_NONE,
	AI_STATE_FIGHTING,
	AI_STATE_FOLLOWING,
	AI_STATE_MISC,
};

//-----------------------------------------------------------------------------------------------
enum ECombatCreatureType
{
	CREATURE_TYPE_HERO = 0,
	CREATURE_TYPE_RIVAL_HERO,
	CREATURE_TYPE_FODDER_CREATURE,
	CREATURE_TYPE_COMBAT_HUMANOID,
	CREATURE_TYPE_COMBAT_ANIMAL,
	CREATURE_TYPE_VILLAGER_MALE,
	CREATURE_TYPE_VILLAGER_FEMALE,
	CREATURE_TYPE_VILLAGER_CHILD,
	CREATURE_TYPE_GUARD,
};

//-----------------------------------------------------------------------------------------------
enum EStatUpdateType
{
	STAT_UPDATE_STRENGTH_EXP = 0,
	STAT_UPDATE_SKILL_EXP,
	STAT_UPDATE_WILL_EXP,
	STAT_UPDATE_GENERAL_EXP,
	STAT_UPDATE_RENOWN,
	STAT_UPDATE_MORALITY,

	STAT_UPDATE_COUNT,
};

//-----------------------------------------------------------------------------------------------
enum EQuestCardPrerequisite
{
	QUEST_PREREQUISITE_RENOWN = 0,
};

//-----------------------------------------------------------------------------------------------
enum EContextSensitiveType
{
	CONTEXT_SENSITIVE_NULL = 0,

	CONTEXT_SENSITIVE_GUILD_SEAL,
	CONTEXT_SENSITIVE_LAMP,
	CONTEXT_SENSITIVE_HEALTH,
	CONTEXT_SENSITIVE_MANA,
	CONTEXT_SENSITIVE_EXPRESSION,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION,
	CONTEXT_SENSITIVE_GIFT,
	CONTEXT_SENSITIVE_MARKER,
	CONTEXT_SENSITIVE_TROPHY,
	CONTEXT_SENSITIVE_SCRIPT,
};

//-----------------------------------------------------------------------------------------------
enum EContextSensitiveExpression
{
	CONTEXT_SENSITIVE_EXPRESSION_NULL = 0,

	CONTEXT_SENSITIVE_EXPRESSION_PICKPOCKET,
	CONTEXT_SENSITIVE_EXPRESSION_PICKLOCK,
	CONTEXT_SENSITIVE_EXPRESSION_STEAL,
	CONTEXT_SENSITIVE_EXPRESSION_FOLLOW,
	CONTEXT_SENSITIVE_EXPRESSION_WAIT,
	CONTEXT_SENSITIVE_EXPRESSION_APOLOGISE,
};

//-----------------------------------------------------------------------------------------------
enum EContextSensitiveOpinionExpression
{
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_OFFENSIVE,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_ATTRACTIVE,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_SCARY,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_AGREEABLE,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_UGLY,
	CONTEXT_SENSITIVE_OPINION_EXPRESSION_RIDICULOUS,

	CONTEXT_SENSITIVE_OPINION_EXPRESSION_LAST
};

//-----------------------------------------------------------------------------------------------
enum EContextSensitiveMarker
{
	CONTEXT_SENSITIVE_MARKER_NULL = 0,

	CONTEXT_SENSITIVE_MARKER_FISHING,
	CONTEXT_SENSITIVE_MARKER_DIGGING,
};

//-----------------------------------------------------------------------------------------------
enum EHeroTitle
{
	TITLE_NONE = 0,

	// player titles
	TITLE_REAPER,
	TITLE_SHADOWHUNTER,
	TITLE_MALEFICUS,
	TITLE_DEATHBRINGER,
	TITLE_ASSASSIN,
	TITLE_NECROMANCER,
	TITLE_AVATAR,
	TITLE_PILGRIM,
	TITLE_LIBERATOR,
	TITLE_PALADIN,
	TITLE_DRUID,
	TITLE_RANGER,
	TITLE_RUNEMASTER,
	TITLE_HOOD,
	TITLE_GLADIATOR,
	TITLE_SABRE,
	TITLE_ARROWDODGER,
	TITLE_PIEMASTER,
	TITLE_CHICKEN_CHASER,
	TITLE_ARSEFACE,

	// rival heroes
	TITLE_JACK,
	TITLE_MAZE,
	TITLE_SCARLET_ROBE,
	TITLE_SCYTHE,
	TITLE_THUNDER,
	TITLE_WHISPER,
	TITLE_TWINBLADE,
	TITLE_BRIAR_ROSE,
	TITLE_LADY_GREY,
	TITLE_GUILDMASTER,

	// TEMP: MS8 test cases
	TITLE_SCORPION_SLAYER,
	TITLE_DEATH_BRINGER,
};

//-----------------------------------------------------------------------------------------------
enum EMiniGameType
{
	MINIGAME_NONE = 0,

	MINIGAME_FISHING,
	MINIGAME_DIGGING,
	MINIGAME_PICKPOCKET,
	MINIGAME_PICKLOCK,
	MINIGAME_STEAL,
	MINIGAME_TROPHY,
	MINIGAME_ORACLE,
};

//-----------------------------------------------------------------------------------------------
enum ECutsceneBehaviour
{
	CUTSCENE_BEHAVIOUR_DEFAULT = 0,
	CUTSCENE_BEHAVIOUR_PAUSED,
	CUTSCENE_BEHAVIOUR_NOT_PAUSED,
};

//-----------------------------------------------------------------------------------------------
enum EHeroTrainingStatus
{
	TRAINING_STATUS_GRADUATED,

	TRAINING_STATUS_APPRENTICE,
	TRAINING_STATUS_BOY,
};

//-----------------------------------------------------------------------------------------------
enum ETutorialCategory
{
	TUTORIAL_CATEGORY_NONE = 0,

	// 'Concept' categories - objects/mechanics in the world.
	TUTORIAL_CATEGORY_ABILITY_ASSIGNING,
	TUTORIAL_CATEGORY_ABILITY_CYCLING,
	TUTORIAL_CATEGORY_BASIC_OBJECTS,
	TUTORIAL_CATEGORY_BED,
	TUTORIAL_CATEGORY_BOASTING,
	TUTORIAL_CATEGORY_CAMERA,
	TUTORIAL_CATEGORY_CHARITY_SHOP,
	TUTORIAL_CATEGORY_CHEST,
	TUTORIAL_CATEGORY_COMBAT_MULTIPLIER,
	TUTORIAL_CATEGORY_CREATURE_DROP,
	TUTORIAL_CATEGORY_DYING,
	TUTORIAL_CATEGORY_DEMON_DOOR,
	TUTORIAL_CATEGORY_DOOR,
	TUTORIAL_CATEGORY_EXPERIENCE,
	TUTORIAL_CATEGORY_EXPERIENCE_SPENDING,
	TUTORIAL_CATEGORY_EXPRESSION,
	TUTORIAL_CATEGORY_FLIRTING,
	TUTORIAL_CATEGORY_FLOURISHING_MOVE,
	TUTORIAL_CATEGORY_GOLDMARKERS,
	TUTORIAL_CATEGORY_GUILD_SEAL,
	TUTORIAL_CATEGORY_INTERACTING,
	TUTORIAL_CATEGORY_INVENTORY,
	TUTORIAL_CATEGORY_INVENTORY_ASSIGNING,
	TUTORIAL_CATEGORY_LEVELLING_UP,
	TUTORIAL_CATEGORY_MORALITY,
	TUTORIAL_CATEGORY_MOVEMENT,
	TUTORIAL_CATEGORY_QUEST,
	TUTORIAL_CATEGORY_QUEST_CARD,
	TUTORIAL_CATEGORY_RENOWN,
	TUTORIAL_CATEGORY_TAKING_QUESTS,
	TUTORIAL_CATEGORY_TELEPORTING,
	TUTORIAL_CATEGORY_TRADE_ITEM,
	TUTORIAL_CATEGORY_SEARCHING,
	TUTORIAL_CATEGORY_SNEAK,
	TUTORIAL_CATEGORY_BUILDING_OWNERSHIP,
	TUTORIAL_CATEGORY_FISHING_GAME,
	TUTORIAL_CATEGORY_ORACLE_GAME,
	TUTORIAL_CATEGORY_WORLD_MAP,

	// 'Item' categories - objects in your inventory.
	TUTORIAL_CATEGORY_ALCOHOL,
	TUTORIAL_CATEGORY_AUGMENTATION,
	TUTORIAL_CATEGORY_ARMOUR,
	TUTORIAL_CATEGORY_BOMB,
	TUTORIAL_CATEGORY_CLOTHES,
	TUTORIAL_CATEGORY_FOOD,
	TUTORIAL_CATEGORY_FISHING_ROD,
	TUTORIAL_CATEGORY_GIFT,
	TUTORIAL_CATEGORY_HAIRSTYLE,
	TUTORIAL_CATEGORY_POTION,
	TUTORIAL_CATEGORY_RESURRECTION_PHIAL,
	TUTORIAL_CATEGORY_SILVER_KEY,
	TUTORIAL_CATEGORY_SPADE,
	TUTORIAL_CATEGORY_TATTOO,
	TUTORIAL_CATEGORY_TROPHY,
	TUTORIAL_CATEGORY_WEAPON,
	TUTORIAL_CATEGORY_WEAPON_LEGENDARY,

	// 'Expression' categories - guess what these are for.
	TUTORIAL_CATEGORY_APOLOGY,
	TUTORIAL_CATEGORY_BATTLE_CRY,
	TUTORIAL_CATEGORY_BELCH,
	TUTORIAL_CATEGORY_EVIL_LAUGH,
	TUTORIAL_CATEGORY_FART,
	TUTORIAL_CATEGORY_FLIRT,
	TUTORIAL_CATEGORY_FOLLOW,
	TUTORIAL_CATEGORY_GIGGLE,
	TUTORIAL_CATEGORY_HEROIC_STANCE,
	TUTORIAL_CATEGORY_MIDDLE_FINGER,
	TUTORIAL_CATEGORY_PELVIC_THRUST,
	TUTORIAL_CATEGORY_PICKLOCK,
	TUTORIAL_CATEGORY_PICKPOCKET,
	TUTORIAL_CATEGORY_SHIT,
	TUTORIAL_CATEGORY_SNEER,
	TUTORIAL_CATEGORY_STEAL,
	TUTORIAL_CATEGORY_THANKS,
	TUTORIAL_CATEGORY_VICTORY_PUMP,
	TUTORIAL_CATEGORY_WAIT,

	TUTORIAL_CATEGORY_COCK_A_DOODLE_DO,
	TUTORIAL_CATEGORY_CROTCH_GRAB,
	TUTORIAL_CATEGORY_KISS_MY_ASS,
	TUTORIAL_CATEGORY_FLAMENCO,
	TUTORIAL_CATEGORY_COSSACK,
	TUTORIAL_CATEGORY_AIR_GUITAR,
	TUTORIAL_CATEGORY_BALLET,
	TUTORIAL_CATEGORY_SATURDAY_NIGHT_FEVER,
	TUTORIAL_CATEGORY_TAP,
	TUTORIAL_CATEGORY_Y,
	TUTORIAL_CATEGORY_M,
	TUTORIAL_CATEGORY_C,
	TUTORIAL_CATEGORY_A,

	// Crimes
	TUTORIAL_CATEGORY_CRIME_WEAPONOUT,
	TUTORIAL_CATEGORY_CRIME_TRESPASSING,
	TUTORIAL_CATEGORY_CRIME_VANDALISM,
	TUTORIAL_CATEGORY_CRIME_THEFT,
	TUTORIAL_CATEGORY_CRIME_ASSAULT,
	TUTORIAL_CATEGORY_CRIME_GBH,
	TUTORIAL_CATEGORY_CRIME_MURDER,

	TUTORIAL_CATEGORY_COUNT,
};

#endif // __MISC_DEF_TYPES_H__
